<#ibiztemplate>
TARGET=PSSYSAPP
</#ibiztemplate>
<?xml version="1.0" encoding="UTF-8"?>
<project xmlns="http://maven.apache.org/POM/4.0.0"
         xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
         xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd">
    <modelVersion>4.0.0</modelVersion>
    <parent>
        <artifactId>${pub.getCodeName()?lower_case}-app</artifactId>
        <groupId>${pub.getPKGCodeName()?lower_case}</groupId>
        <version>${pub.getVersionString()?default("V0.0.1_alpha")}</version>
    </parent>

    <artifactId>${pub.getCodeName()?lower_case}-app-${app.getPKGCodeName()?lower_case}</artifactId>
    <name>${pub.getCodeName()?lower_case?cap_first} Gateway ${app.getPKGCodeName()}</name>
    <description>${pub.getCodeName()?lower_case?cap_first} ${app.getPKGCodeName()}</description>

    <dependencies>
		<dependency>
			<groupId>${pub.getPKGCodeName()?lower_case}</groupId>
			<artifactId>${pub.getCodeName()?lower_case}-util</artifactId>
			<version>${r'${project.version}'}</version>
		</dependency>
<#if app.getAppMode()?? && app.getAppMode() == "WFAPP">
        <dependency>
            <groupId>${pub.getPKGCodeName()?lower_case}</groupId>
			<artifactId>${pub.getCodeName()?lower_case}-workflow</artifactId>
			<version>${r'${project.version}'}</version>
        </dependency>
</#if>
    </dependencies>

<#if pub.getPSDeployCenter()?? && pub.getPSDeployCenter().getPSRegistryRepo()??>
    <properties>
        <docker.image.prefix>${pub.getPSDeployCenter().getPSRegistryRepo().getConnStr()}</docker.image.prefix>
    </properties>
</#if>


    <profiles>
        <profile>
            <id>${app.getPKGCodeName()?lower_case}</id>
            <build>
                <resources>
                    <resource>
                        <directory>${r'${basedir}'}/src/main/webapp</directory>
                        <!--注意此次必须要放在此目录下才能被访问到 -->
                        <targetPath>META-INF/resources</targetPath>
                        <includes>
                            <include>**/**</include>
                        </includes>
                    </resource>
                    <resource>
                        <directory>${r'${basedir}'}/src/main/resources</directory>
                        <includes>
                            <include>**/**</include>
                        </includes>
                    </resource>
                </resources>
                <plugins>
                    <plugin>
                        <groupId>org.codehaus.mojo</groupId>
                        <artifactId>exec-maven-plugin</artifactId>
                        <version>1.6.0</version>
                        <executions>
                            <execution>
                                <id>exec-yarn-run-install</id>
                                <phase>prepare-package</phase>
                                <goals>
                                    <goal>exec</goal>
                                </goals>
                                <configuration>
                                    <executable>yarn</executable>
                                    <workingDirectory>../../app_${app.getPKGCodeName()}</workingDirectory>
                                </configuration>
                            </execution>
                            <execution>
                                <id>exec-yarn-run-build</id>
                                <phase>prepare-package</phase>
                                <goals>
                                    <goal>exec</goal>
                                </goals>
                                <configuration>
                                    <executable>yarn</executable>
                                    <arguments>
                                        <argument>build</argument>
                                    </arguments>
                                    <workingDirectory>../../app_${app.getPKGCodeName()}</workingDirectory>
                                </configuration>
                            </execution>
                        </executions>
                    </plugin>

                    <plugin>
                        <groupId>org.springframework.boot</groupId>
                        <artifactId>spring-boot-maven-plugin</artifactId>
                        <configuration>
                            <finalName>${pub.getCodeName()?lower_case}-app-${app.getPKGCodeName()?lower_case}</finalName>
                            <jvmArguments>-Dfile.encoding=UTF-8</jvmArguments>
                            <mainClass>${pub.getPKGCodeName()}.${app.getPKGCodeName()?lower_case}.${app.getPKGCodeName()}Application</mainClass>
                            <outputDirectory>../../</outputDirectory>
                        </configuration>
                        <executions>
                            <execution>
                                <goals>
                                    <goal>repackage</goal>
                                </goals>
                            </execution>
                        </executions>
                    </plugin>
                    
<#if pub.getPSDeployCenter()?? && pub.getPSDeployCenter().getPSRegistryRepo()??>
                    <plugin>
                            <groupId>com.spotify</groupId>
                            <artifactId>docker-maven-plugin</artifactId>
                            <version>0.4.13</version>
                            <configuration>
                            <serverId>ibiz-dev</serverId>
                            <imageName>${r'${docker.image.prefix}/${project.artifactId}'}:latest</imageName>
                            <dockerDirectory>${r'${project.basedir}'}/src/main/docker</dockerDirectory>
                            <resources>
                                <resource>
                                    <targetPath>/</targetPath>
                                    <directory>../../</directory>
                                    <include>${r'${project.artifactId}'}.jar</include>
                                </resource>
                            </resources>
                            </configuration>
                    </plugin>
</#if>                    
                </plugins>
            </build>
        </profile>
    </profiles>

</project>

